using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmEquipmentInventory
	/// </summary>
	public class FrmEquipmentInventory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvEquipmentReport;
		private System.ComponentModel.IContainer components = null;
        private DataSet _dsReport = new DataSet();
		//

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="equipmentGuid"></param>
		public FrmEquipmentInventory(Guid equipmentGuid)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
			//
			using (new WaitCursor())
			{
				this.CreateReport(equipmentGuid);
			}

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmEquipmentInventory));
            this.grpImage1 = new System.Windows.Forms.GroupBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvEquipmentReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Equipment Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage1
            // 
            this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage1.Controls.Add(this.pictureBox2);
            this.grpImage1.Location = new System.Drawing.Point(3, 32);
            this.grpImage1.Name = "grpImage1";
            this.grpImage1.Size = new System.Drawing.Size(53, 412);
            this.grpImage1.TabIndex = 4;
            this.grpImage1.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 8);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(45, 45);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(563, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(483, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvEquipmentReport
            // 
            this.rvEquipmentReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvEquipmentReport.Location = new System.Drawing.Point(59, 37);
            this.rvEquipmentReport.Name = "rvEquipmentReport";
            this.rvEquipmentReport.Size = new System.Drawing.Size(579, 405);
            this.rvEquipmentReport.TabIndex = 6;
            // 
            // FrmEquipmentInventory
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvEquipmentReport);
            this.Controls.Add(this.grpImage1);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Maintain_Equipment.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 500);
            this.Name = "FrmEquipmentInventory";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Equipment Report";
            this.Load += new System.EventHandler(this.FrmEquipmentInventory_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage1, 0);
            this.Controls.SetChildIndex(this.rvEquipmentReport, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage1.ResumeLayout(false);
            this.grpImage1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

	

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC022.FrmEquipmentInventory());
			//
			this.SetThisToolTip(this.btnPrint,Common.StrRes.Tooltips.Common.Print());
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Close());
            BOL.VbecsReport.SetUpReportButtons(this.rvEquipmentReport);
        }

		private void CreateReport(Guid equipmentGuid)
		{
			_dsReport = BOL.Equipment.GetEquipmentReport(equipmentGuid);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter("None");

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "EquipmentReportDataSet";
                reportSourceMain.Value = _dsReport.Tables[Common.VbecsTables.Equipment.TableName];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.EquipmentReport.EquipmentReport.rdlc");
            Stream streamMaintenance = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.EquipmentReport.EquipmentMaintenance.rdlc");
            Stream streamHistory = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.EquipmentReport.EquipmentHistory.rdlc");
            Stream streamAddressHistory = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.EquipmentReport.EquipmentAddressHistory.rdlc");

            this.rvEquipmentReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);
            
            this.rvEquipmentReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvEquipmentReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvEquipmentReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvEquipmentReport.LocalReport.LoadReportDefinition(stream);
            this.rvEquipmentReport.LocalReport.LoadSubreportDefinition("EquipmentMaintenance", streamMaintenance);
            this.rvEquipmentReport.LocalReport.LoadSubreportDefinition("EquipmentHistory", streamHistory);
            this.rvEquipmentReport.LocalReport.LoadSubreportDefinition("EquipmentAddressHistory", streamAddressHistory);

            this.rvEquipmentReport.RefreshReport();
 
            //
#if DEBUG
			//dsPrint.Tables[Common.VbecsTables.Equipment.TableName].WriteXml("e:\\temp\\EquipmentReportDataSet.xml", XmlWriteMode.WriteSchema);
            //dsPrint.Tables[Common.VbecsTables.EquipmentMaintenance.TableName].WriteXml("e:\\temp\\EquipmentMaintenanceDataSet.xml", XmlWriteMode.WriteSchema);
            //dsPrint.Tables["EquipmentMirror"].WriteXml("e:\\temp\\EquipmentHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            //dsPrint.Tables["AddressMirror"].WriteXml("e:\\temp\\EquipmentAddressHistoryDataSet.xml", XmlWriteMode.WriteSchema);
#endif

		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "EquipmentMaintenance" || e.DataSourceNames[0].ToString() == "EquipmentMaintenanceDataSet")
            {
                ReportDataSource reportMaintenance = new ReportDataSource();
                if (_dsReport.Tables.IndexOf(Common.VbecsTables.EquipmentMaintenance.TableName) != -1)
                {
                    reportMaintenance.Name = "EquipmentMaintenanceDataSet";
                    reportMaintenance.Value = _dsReport.Tables[Common.VbecsTables.EquipmentMaintenance.TableName];
                }
                e.DataSources.Add(reportMaintenance);
            }
            else if (e.ReportPath == "EquipmentHistory" || e.DataSourceNames[0].ToString() == "EquipmentHistoryDataSet")
            {
                ReportDataSource reportHistory = new ReportDataSource();
                if (_dsReport.Tables.IndexOf("EquipmentMirror") != -1)
                {
                    reportHistory.Name = "EquipmentHistoryDataSet";
                    reportHistory.Value = _dsReport.Tables["EquipmentMirror"];
                }
                e.DataSources.Add(reportHistory);
            }
            else if (e.ReportPath == "EquipmentAddressHistory" || e.DataSourceNames[0].ToString() == "EquipmentAddressHistoryDataSet")
            {
                ReportDataSource reportAddressHistory = new ReportDataSource();
                if (_dsReport.Tables.IndexOf("AddressMirror") != -1)
                {
                    reportAddressHistory.Name = "EquipmentAddressHistoryDataSet";
                    reportAddressHistory.Value = _dsReport.Tables["AddressMirror"];
                }
                e.DataSources.Add(reportAddressHistory);
            }
        }

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvEquipmentReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmEquipmentInventory_Load(object sender, EventArgs e)
        {

            this.rvEquipmentReport.RefreshReport();
        }
	}
}

